<?php
/**
 * Plugin Name: Laster Poster Trophy on Postbit v1.0 for MyBB 1.6.*
 * Copyright © 2012 Wildcard
 * http://www.rantcentralforums.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses
 */

// Deny outside access.
if(!defined("IN_MYBB")){

	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");

}

// Used by MyBB to provide relevant information about the plugin and also link users to updates.
function last_poster_info()
{
	global $db, $mybb, $lang;

	$lang->load("last_poster");

	// Get the gid for the settings group (needed for settings link in description)
	$query = $db->simple_select("settinggroups", "gid", "name='last_poster_settings'", array("order_dir" => 'DESC'));
	$groupquery = $db->fetch_array($query);
	$gid = $groupquery['gid'];

	if($gid == "")
	{
		$last_poster_settings_link = "<br />";
	}
	else
	{
		$last_poster_settings_link = "<ul><li><a href=\"" . $mybb->settings['bburl'] . "/admin/index.php?module=config-settings&amp;action=change&amp;gid=" . $gid . "\" target=\"_blank\">" . $lang->last_poster_plugin_settings . "</a></li></ul>";
	}

	return array(
		"name" 				=> "Laster Poster Trophy on Postbit",
		"description" 		=> $lang->last_poster_description . $last_poster_settings_link,
		"website" 			=> "http://www.rantcentralforums.com",
		"author" 			=> "Wildcard",
		"authorsite" 		=> "http://www.rantcentralforums.com",
		"version" 			=> "1.01",
		"compatibility" 	=> "16*",
		'guid'					=> '1c051ccc057b513901ffc5687ec0c9d1'
		);
}

// Checks to see if the plugin's settingsgroup is installed. If so then assume the plugin is installed.
function last_poster_is_installed ()
{
	global $db;
	$query = $db->simple_select("settinggroups", "name", "name='last_poster_settings'", array("order_dir" => 'DESC'));

	return $db->num_rows($query);

}

// Install the plugin settingsgroup and settings.
function last_poster_install()
{
	global $db, $lang;

	$lang->load("last_poster");

	// The group
	$last_poster_group = array(
		"gid" 				=> "NULL",
		"name" 				=> "last_poster_settings",
		"title" 				=> "Laster Poster Trophy on Postbit",
		"description" 		=> $lang->last_poster_settings_description,
		"disporder" 		=> "100",
		"isdefault" 			=> "no",
	);
	$db->insert_query("settinggroups", $last_poster_group);

	// Grab the settingsgroup ID
	$gid = $db->insert_id();

	// The settings
	$last_poster_setting_1 = array(
		"sid"					=> "NULL",
		"name"				=> "last_poster_setting1",
		"title"					=> $lang->last_poster_show_on_postbit,
		"description"		=> "",
		"optionscode"	=> "yesno",
		"value"				=> '1',
		"disporder"		=> '1',
		"gid"					=> intval($gid),
	);
	$last_poster_setting_2 = array(
		"sid"					=> "NULL",
		"name"				=> "last_poster_setting2",
		"title"					=> $lang->last_poster_thread_id,
		"description"		=> $lang->last_poster_thread_id_description,
		"optionscode"	=> "text",
		"value"				=> '',
		"disporder"		=> '2',
		"gid"					=> intval($gid),
	);
	$last_poster_setting_3 = array(
		"sid"					=> "NULL",
		"name"				=> "last_poster_setting3",
		"title"					=> $lang->last_poster_trophy_image_location,
		"description"		=> $lang->last_poster_trophy_image_location_description,
		"optionscode"	=> "text",
		"value"				=> 'images/trophy.png',
		"disporder"		=> '3',
		"gid"					=> intval($gid),
	);

	$db->insert_query("settings", $last_poster_setting_1);
	$db->insert_query("settings", $last_poster_setting_2);
	$db->insert_query("settings", $last_poster_setting_3);

	rebuild_settings();

}

function last_poster_activate()
{
	// Do nothing
}

function last_poster_deactivate()
{
	// Do nothing
}

// Remove the settingsgroup and settings to uninstall
function last_poster_uninstall ()
{
	global $db;
	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='last_poster_settings'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='last_poster_setting1'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='last_poster_setting2'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='last_poster_setting3'");

	rebuild_settings();

}

// Hook into the postbit
$plugins->add_hook("postbit", "last_poster_run");

// Determine if the user is the current winner of the last poster thread and if so show the trophy on their postbit.
function last_poster_run(&$post)
{
	global $db, $mybb, $lang;

	$lang->load("last_poster");

	// Setting1=Show on Postbit? (True=yes) Setting2=Last Poster Wins Thread ID
	if($mybb->settings['last_poster_setting1'] && $mybb->settings['last_poster_setting2'])
	{
		static $last_poster = null;
		
		if(!isset($last_poster))
		{
			// Find the last two posts in the 'Last Poster Wins' thread
			$last_post_query = $db->simple_select("posts", "uid", "tid=" . intval($mybb->settings['last_poster_setting2']), array("order_by" => 'dateline', "order_dir" => 'DESC', "limit" => 2));
			
			if ($db->num_rows($last_post_query) > 0)
			{
				// Get the last two posters
				$row = $db->fetch_array($last_post_query);
				$last_poster = $row['uid'];
				
				$row = $db->fetch_array($last_post_query);
				$next_to_last_poster = $row['uid'];
			}
		}
		
		if($last_poster > 0)
		{
			// Is this user the current winner?
			if($post['uid'] == $last_poster)
			{
				// We only need the JavaScript to clear the old winner's trophies
				//  * if we are in the LPW thread AND
				//  * it wasn't the same poster 'winning' twice (double post)
				if($last_poster == $next_to_last_poster || $post['tid'] != intval($mybb->settings['last_poster_setting2']))
				{
					// No need to clear the old winners trophy.
					$lpw_trophy_script = "";
				}
				else
				{
					// Include JavaScript to hide the previous winner's trophy image(s) that are on the same page.
					$lpw_trophy_script = "onload=\"var x=document.getElementsByName('lpt_{$next_to_last_poster}'); for(count=0; count < x.length; count++){ x[count].style.display='none'; }\"";
				}

				$post['user_details'] = "{$post['user_details']}<br/><img src=\"{$mybb->settings['bburl']}/{$mybb->settings['last_poster_setting3']}\" name=\"lpt_{$last_poster}\" {$lpw_trophy_script} alt=\"{$lang->last_poster_trophy_image_alt}\" title=\"{$lang->last_poster_trophy_image_alt}\" />";
			}
		}
	}
}

?>